<?php

/**
 * 
 * @package		PageFlex
 * @author		PageFlex Team (vudoanthang83@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
define('ABSPATH', preg_replace('/\\\/', '/', dirname(dirname(__FILE__))));
$relative_path = (strpos($_SERVER["SCRIPT_NAME"], '/admin/') !== false) ? dirname(substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/'))) : substr($_SERVER['SCRIPT_NAME'], 0, strrpos($_SERVER['SCRIPT_NAME'], '/'));
define('RELATIVE_PATH', (strlen($relative_path) > 1) ? $relative_path : '');

define('PLUGIN_PATH', ABSPATH . '/plugins');
define('ADMIN_PLUGIN_PATH', ABSPATH . '/admin/plugins');

define('RELATIVE_PLUGIN_PATH', RELATIVE_PATH . '/plugins');
define('RELATIVE_ADMIN_PLUGIN_PATH', RELATIVE_PATH . '/admin/plugins');

define('WIDGET_PATH', ABSPATH . '/themes/%s/widgets');

// A random string used in security hashing methods.
define('__SECURITY_SALT__', '');

// A random numeric string (digits only) used to encrypt/decrypt strings.
define('__SECURITY_CIPHER_SEED__', '');


/** Debug */
define('DEBUG', false);

if (DEBUG == true) {
    error_reporting(-1);
}

/** The name of the database for PageFlex */
define('DB_NAME', '');

/** MySQL database username */
define('DB_USER', '');

/** MySQL database password */
define('DB_PASSWORD', '');

/** MySQL hostname */
define('DB_HOST', '');

/** Database Charset to use in creating database tables. */
define('DB_CHARSET', 'utf8');

/** The Database Collate type. */
define('DB_COLLATE', 'utf8_general_ci');

if (get_magic_quotes_gpc()) {

    function stripslashes_array($array)
    {
        return is_array($array) ? array_map('stripslashes_array', $array) : stripslashes($array);
    }

    $_GET = stripslashes_array($_GET);
    $_POST = stripslashes_array($_POST);
    $_COOKIE = stripslashes_array($_COOKIE);
}
global $html_charset_list;
$html_charset_list = array(
    'utf-8'=>'UTF-8',
    'gb2312'=>'Chinese Simplified (GB2312)',
    'iso-8859-1'=>'Western Alphabet',
    'iso-8859-2'=>'Central European Alphabet (ISO)',
    'shift-jis'=>'Japanese (Shift-JIS)',
);
/* * **** TINYMCE CONFIGURE ******** */
define('__TINYMCE_MENUBAR__', 'table format view insert edit tools'); // string ('tools table format view insert edit' | 'false')

$tinymce_plugins = '[
        "responsivefilemanager advlist autolink lists link image charmap print preview anchor",
        "searchreplace visualblocks pageflex fullscreen",
        "insertdatetime media table contextmenu paste textcolor emoticons"
    ]';
define('__TINYMCE_PLUGINS__', $tinymce_plugins);

$tinymce_toolbar = 'toolbar1: "pageflex responsivefilemanager | undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | print preview media | forecolor backcolor emoticons | link image | styleselect | fontselect | fontsizeselect"';
define('__TINYMCE_TOOLBAR__', $tinymce_toolbar);


/** PageFlex Version */
define('PF_VERSION','1.1');

/** MOD_REWRITE */
define('MOD_REWRITE',true);